/*
 * Decompiled with CFR 0.152.
 */
package com.dbschools.picker;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.jnlp.ClipboardService;
import javax.jnlp.FileContents;
import javax.jnlp.FileOpenService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamesDialog
extends JDialog {
    private JTabbedPane tabbedPane;
    private final String lineSep = System.getProperty("line.separator");
    private final List<String> names = new ArrayList<String>();
    private int maxPicks;
    private final List<Section> sections = new ArrayList<Section>();
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JMenuBar jMenuBar1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JTextArea jTextAreaNames;
    private JSpinner maxPicksSpinner;
    private JMenu menuEdit;
    private JMenuItem menuEditPaste;
    private JMenu menuFile;
    private JPanel namesPanel;
    private JMenuItem openMenu;

    public NamesDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setLocationRelativeTo(parent);
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.maxPicksSpinner = new JSpinner();
        this.jPanel2 = new JPanel();
        this.jButtonOK = new JButton();
        this.namesPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaNames = new JTextArea();
        this.jMenuBar1 = new JMenuBar();
        this.menuFile = new JMenu();
        this.openMenu = new JMenuItem();
        this.menuEdit = new JMenu();
        this.menuEditPaste = new JMenuItem();
        ResourceBundle bundle = ResourceBundle.getBundle("com/dbschools/picker/strings");
        this.setTitle(bundle.getString("namesTitle"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                NamesDialog.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.jLabel2.setText(bundle.getString("namesInstructions"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel1.setText(bundle.getString("maxTimesEach"));
        this.jPanel1.add(this.jLabel1);
        this.maxPicksSpinner.setModel(new SpinnerNumberModel((Number)3, Integer.valueOf(1), null, (Number)1));
        this.jPanel1.add(this.maxPicksSpinner);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 0);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText(bundle.getString("ok"));
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NamesDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jButtonOK);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.namesPanel.setPreferredSize(new Dimension(300, 400));
        this.namesPanel.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView(this.jTextAreaNames);
        this.namesPanel.add((Component)this.jScrollPane1, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.namesPanel, gridBagConstraints);
        this.menuFile.setMnemonic('f');
        this.menuFile.setText(bundle.getString("file"));
        this.openMenu.setMnemonic('o');
        this.openMenu.setText(bundle.getString("open"));
        this.openMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NamesDialog.this.openMenuActionPerformed(evt);
            }
        });
        this.menuFile.add(this.openMenu);
        this.jMenuBar1.add(this.menuFile);
        this.menuEdit.setMnemonic('e');
        this.menuEdit.setText(bundle.getString("edit"));
        this.menuEditPaste.setText(bundle.getString("paste"));
        this.menuEditPaste.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NamesDialog.this.menuEditPasteActionPerformed(evt);
            }
        });
        this.menuEdit.add(this.menuEditPaste);
        this.jMenuBar1.add(this.menuEdit);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void openMenuActionPerformed(ActionEvent evt) {
        String fileContents = this.getFileContents();
        if (fileContents != null) {
            if (fileContents.charAt(0) == ':') {
                for (String sectionData : fileContents.split(":")) {
                    if (sectionData.trim().length() <= 0) continue;
                    this.sections.add(new Section(sectionData));
                }
                this.namesPanel.remove(this.jScrollPane1);
                this.tabbedPane = new JTabbedPane();
                this.namesPanel.add((Component)this.tabbedPane, "Center");
                this.addTabs();
            } else {
                this.jTextAreaNames.setText(fileContents);
            }
        }
    }

    private void addTabs() {
        for (Section section : this.sections) {
            this.tabbedPane.addTab(section.getTitle(), new JScrollPane(new JTextArea(section.getData())));
        }
    }

    private String getFileContents() {
        String fileContents = null;
        try {
            FileOpenService fos = (FileOpenService)ServiceManager.lookup((String)FileOpenService.class.getName());
            FileContents contents = fos.openFileDialog(null, null);
            if (contents != null) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(contents.getInputStream()));
                long dataLength = contents.getLength();
                if (dataLength > 0L) {
                    char[] buf = new char[(int)dataLength];
                    bufferedReader.read(buf);
                    fileContents = new String(buf);
                }
            }
        }
        catch (UnavailableServiceException e) {
            fileContents = ":Math" + this.lineSep + "Dave" + this.lineSep + "Devon" + this.lineSep + ":Science" + this.lineSep + "Anne" + this.lineSep + "Ardy";
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fileContents;
    }

    private void menuEditPasteActionPerformed(ActionEvent evt) {
        try {
            ClipboardService cs = (ClipboardService)ServiceManager.lookup((String)ClipboardService.class.getName());
            Transferable tr = cs.getContents();
            if (tr.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    String s = (String)tr.getTransferData(DataFlavor.stringFlavor);
                    this.jTextAreaNames.setText(s);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (UnavailableServiceException unavailableServiceException) {
            // empty catch block
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        String text = this.sections.size() == 0 ? this.jTextAreaNames.getText() : this.sections.get(this.tabbedPane.getSelectedIndex()).getData();
        this.names.clear();
        if (text.trim().length() > 0) {
            for (String name : text.split("\n")) {
                if (name.trim().length() <= 0) continue;
                this.names.add(name);
            }
        }
        this.maxPicks = (Integer)this.maxPicksSpinner.getValue();
        this.setVisible(false);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
    }

    public int getMaxPicks() {
        return this.maxPicks;
    }

    public List<String> getNames() {
        return this.names;
    }

    private class Section {
        private final String title;
        private final String data;

        Section(String sectionData) {
            int i = sectionData.indexOf(NamesDialog.this.lineSep);
            this.title = sectionData.substring(0, i);
            this.data = sectionData.substring(i + NamesDialog.this.lineSep.length());
        }

        public String getData() {
            return this.data;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

