/*
 * Decompiled with CFR 0.152.
 */
package com.dbschools.picker;

import com.dbschools.gui.barcell.BarCellRenderer;
import com.dbschools.gui.barcell.BarCellValue;
import com.dbschools.picker.NamesDialog;
import com.dbschools.picker.Picker;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Synthesizer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Panel
extends JPanel {
    private static Logger log = Logger.getLogger(Panel.class.getName());
    private AbstractTableModel model;
    private JFrame appFrame;
    private NamesDialog namesDialog;
    private MidiChannel channel;
    private Picker picker = new Picker();
    private JCheckBox fanfareCheckBox;
    private JButton jButtonHelp;
    private JButton jButtonNames;
    private JButton jButtonPick;
    private JLabel jLabelSelected;
    private JPanel jPanelButtons;
    private JScrollPane jScrollPane1;
    private JTable jTable1;

    public Panel() {
        try {
            Synthesizer synthesizer = MidiSystem.getSynthesizer();
            synthesizer.open();
            this.channel = synthesizer.getChannels()[9];
        }
        catch (MidiUnavailableException ex) {
            System.out.println(ex);
        }
        this.initComponents();
        this.picker.addListener(new Picker.Listener(){

            public void itemSelected(int itemIndex, boolean isFinal) {
                ListSelectionModel sm = Panel.this.jTable1.getSelectionModel();
                int midiNote = 75;
                Panel.this.channel.noteOff(75);
                Panel.this.channel.noteOn(75, 127);
                try {
                    Thread.sleep(80L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                sm.setSelectionInterval(itemIndex, itemIndex);
                Panel.this.jLabelSelected.setText(Panel.this.picker.getNames().get(itemIndex));
                if (isFinal) {
                    if (Panel.this.picker.getNumPicksRemaining() == 0) {
                        Panel.this.jButtonPick.setText("Reset");
                    }
                    Panel.this.model.fireTableRowsUpdated(itemIndex, itemIndex);
                }
            }
        });
        BarCellRenderer.setForTable((JTable)this.jTable1);
        this.model = new AbstractTableModel(){
            private String[] headings = new String[]{"Name", "Remaining"};
            private Class<?>[] classes = new Class[]{String.class, BarCellValue.class};

            @Override
            public int getColumnCount() {
                return this.headings.length;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return this.classes[columnIndex];
            }

            @Override
            public String getColumnName(int index) {
                return this.headings[index];
            }

            @Override
            public int getRowCount() {
                return Panel.this.picker.getNames() == null ? 0 : Panel.this.picker.getNames().size();
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                String value = null;
                switch (columnIndex) {
                    case 0: {
                        value = Panel.this.picker.getNames().get(rowIndex);
                        break;
                    }
                    case 1: {
                        value = new BarCellValue(new Double(Panel.this.picker.getRemaining(rowIndex)), new Double(Panel.this.picker.getMaxPicks()));
                    }
                }
                return value;
            }
        };
        this.jTable1.setModel(this.model);
        TableColumnModel columnModel = this.jTable1.getColumnModel();
        TableColumn column = columnModel.getColumn(1);
        column.setPreferredWidth(100);
        column.setMaxWidth(100);
    }

    void setMaxPicks(int maxPicks) {
        this.picker.setMaxPicks(maxPicks);
    }

    void setNames(List<String> names) {
        this.picker.setNames(names);
    }

    void begin() {
        this.preparePickingHat();
    }

    private void initComponents() {
        this.jLabelSelected = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanelButtons = new JPanel();
        this.jButtonHelp = new JButton();
        this.jButtonNames = new JButton();
        this.jButtonPick = new JButton();
        this.fanfareCheckBox = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.jLabelSelected.setFont(new Font("Serif", 1, 72));
        this.jLabelSelected.setHorizontalAlignment(0);
        this.jLabelSelected.setText(" ");
        ResourceBundle bundle = ResourceBundle.getBundle("com/dbschools/picker/strings");
        this.jLabelSelected.setToolTipText(bundle.getString("helpSelected"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 4, 8, 4);
        this.add((Component)this.jLabelSelected, gridBagConstraints);
        this.jScrollPane1.setToolTipText(bundle.getString("namesListHelp"));
        this.jTable1.setModel(new DefaultTableModel(new Object[0][], new String[]{"Name", "Remaining"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Integer.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane1.setViewportView(this.jTable1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jButtonHelp.setMnemonic('h');
        this.jButtonHelp.setText(bundle.getString("helpButton"));
        this.jButtonHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Panel.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jPanelButtons.add(this.jButtonHelp);
        this.jButtonNames.setMnemonic('n');
        this.jButtonNames.setText(bundle.getString("names"));
        this.jButtonNames.setToolTipText(bundle.getString("namesHelp"));
        this.jButtonNames.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Panel.this.jButtonNamesActionPerformed(evt);
            }
        });
        this.jPanelButtons.add(this.jButtonNames);
        this.jButtonPick.setMnemonic('p');
        this.jButtonPick.setText(bundle.getString("pick"));
        this.jButtonPick.setToolTipText(bundle.getString("pickHelp"));
        this.jButtonPick.setEnabled(false);
        this.jButtonPick.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Panel.this.jButtonPickActionPerformed(evt);
            }
        });
        this.jPanelButtons.add(this.jButtonPick);
        this.fanfareCheckBox.setMnemonic('f');
        this.fanfareCheckBox.setSelected(true);
        this.fanfareCheckBox.setText("Fanfare");
        this.jPanelButtons.add(this.fanfareCheckBox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jPanelButtons, gridBagConstraints);
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this.getAppFrame(), ResourceBundle.getBundle("com/dbschools/picker/strings").getString("helpText"));
    }

    private void jButtonNamesActionPerformed(ActionEvent evt) {
        this.jLabelSelected.setText(" ");
        if (this.namesDialog == null) {
            this.namesDialog = new NamesDialog((Frame)this.getAppFrame(), true);
        }
        this.namesDialog.setVisible(true);
        this.picker.setNames(this.namesDialog.getNames());
        this.picker.setMaxPicks(this.namesDialog.getMaxPicks());
        this.preparePickingHat();
    }

    private void jButtonPickActionPerformed(ActionEvent evt) {
        this.picker.setFanfare(this.fanfareCheckBox.isSelected());
        if (this.picker.getNumPicksRemaining() == 0) {
            this.preparePickingHat();
            return;
        }
        this.picker.pick();
    }

    private void preparePickingHat() {
        this.jButtonPick.setText("Pick");
        this.jLabelSelected.setText(" ");
        if (this.picker.getNames().size() > 0) {
            this.picker.prepareHat();
            this.model.fireTableDataChanged();
            this.jButtonPick.setEnabled(this.picker.getNames().size() > 0);
        }
    }

    public JFrame getAppFrame() {
        return this.appFrame;
    }

    public void setAppFrame(JFrame appFrame) {
        this.appFrame = appFrame;
    }
}

