/*
 * Decompiled with CFR 0.152.
 */
package com.dbschools.picker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Picker {
    private static Logger log = Logger.getLogger(Picker.class.getName());
    private Thread thread;
    private boolean fanfare;
    private List<String> names;
    private int maxPicks = 1;
    private final List<Integer> pickingHat = new ArrayList<Integer>();
    private int[] remaining;
    private Collection<Listener> pickerListeners = Collections.synchronizedList(new ArrayList());

    Picker() {
    }

    private Integer chooseFromHat(boolean remove) {
        Integer item;
        int itemIndex = (int)(Math.random() * (double)this.pickingHat.size());
        Integer n = item = remove ? this.pickingHat.remove(itemIndex) : this.pickingHat.get(itemIndex);
        if (remove) {
            int n2 = item;
            this.remaining[n2] = this.remaining[n2] - 1;
        }
        return item;
    }

    private void selectAndNotify(final boolean isFinal) {
        final int result = this.chooseFromHat(isFinal);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                for (Listener pl : Picker.this.pickerListeners) {
                    pl.itemSelected(result, isFinal);
                }
            }
        });
    }

    void waitForFanfareEnd() {
        if (this.thread == null) {
            return;
        }
        try {
            this.thread.join();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(Picker.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    void pick() {
        if (this.names == null) {
            throw new IllegalStateException("must call setNames");
        }
        if (this.pickingHat.size() == 0) {
            throw new IllegalStateException("must call prepareHat");
        }
        if (!this.fanfare || this.pickingHat.size() == 1) {
            this.selectAndNotify(true);
            return;
        }
        this.thread = new Thread(new Runnable(){

            public void run() {
                long sleepTime = 0 + (int)(100.0 * Math.random());
                long highSleepTime = 400L;
                while (true) {
                    if (sleepTime > highSleepTime) {
                        Picker.this.selectAndNotify(true);
                        return;
                    }
                    Picker.this.selectAndNotify(false);
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    sleepTime += 50L;
                }
            }
        }, "Picking fanfare");
        this.thread.start();
    }

    void prepareHat() {
        this.pickingHat.clear();
        this.remaining = new int[this.names.size()];
        for (int i = 0; i < this.names.size(); ++i) {
            this.remaining[i] = this.maxPicks;
            for (int j = 0; j < this.maxPicks; ++j) {
                this.pickingHat.add(i);
            }
        }
    }

    int getRemaining(int index) {
        return this.remaining[index];
    }

    void setFanfare(boolean fanfare) {
        this.fanfare = fanfare;
    }

    void addListener(Listener listener) {
        this.pickerListeners.add(listener);
    }

    void removeListener(Listener listener) {
        this.pickerListeners.remove(listener);
    }

    public int getMaxPicks() {
        return this.maxPicks;
    }

    public void setMaxPicks(int maxPicks) {
        this.maxPicks = maxPicks;
    }

    public List<String> getNames() {
        return this.names;
    }

    public int getNumPicksRemaining() {
        return this.pickingHat.size();
    }

    public void setNames(List<String> names) {
        this.names = names;
    }

    static interface Listener {
        public void itemSelected(int var1, boolean var2);
    }
}

